/* Programme d'indentation des codes sources C.
Programmé par Maniack Crudelis.
http://www.crudelis.fr
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
Version 2.0. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "Utilitaire.h"
#include "Fichier.h"

void desindenteur (FILE* fichier);        /*fait une copie desindentée du fichier dans tmp.txt. Depuis l'emplacement du curseur.*/
void indenteur (char* chaine, FILE* tmp2, int nbmit);   /*fait une copie indentée (de nbmit * 4 espaces) de la chaine dans tmp2. Depuis l'emplacement du curseur*/
void cmd_indent_1 (FILE* tmp);                        /*Commande l'indentation du source suivant les accolades et les cases*/
void cmd_indent_2 (FILE* tmp2,FILE* fichier_final);                         /*commande l'indentation du source suivant les mots clés sans accolades*/
int verif_com_guil (char* chainecomplete, char* chainepartielle, int mot, int* comptcom);   /*renvoi 0 si la chainepartielle se trouve dans un commentaire, dans une string ou dans un nom de variable. Renvoi 1 sinon. Indiquer 0 pour mot si la string n'estpas un mot clé*/
void compteur_com (char*chainecomplete, int* comptcom);     /*vérifie que les commentaires soit fermé*/
void Traitement_1 (FILE* fichier); /*Effectue la première partie du traitement, c'est a dire indentation selon les accolades et les case. */
void Traitement_2 (FILE* fichier_final); /*Effectue la deuxieme partie du traitement, c'est a dire indentation selon les mots clés non suivi d'accolade (1 seule ligne.). */
void fprintstr (FILE* fichier, char* chaine);                                   /* ecrit la chaine dans le fichier, en respectant les %*/
void Pause ();

int main (int argc,char *argv[])
{
    char* nomfichier1;
    char* nomfichier2;
    char rep;
    FILE* fichier;
    FILE* fichier_final;
    #ifndef WIN32    /*linux*/
        startxterm (argc,argv,"Indenteur C","O7");
    #endif
    puts("*******************************************************************************");
    puts("**                                                                           **");
    puts("*                  Programme indenteur pour fichier source C                  *");
    puts("**                                                                           **");
    puts("*******************************************************************************");
    puts("");
    puts("Attention, ce programme peut mal fonctionner dans certains cas.");
    puts("Les contraintes sont enonces ci-dessous:");
    puts("  - Le code source a indenter doit se terminer par une ligne vierge.");
    puts("  - Le nom ou le chemin du fichier a indenter ne doit pas comporter de          caracteres accentuees.");
    puts("");
    puts("Quel fichier voulez-vous indenter? :");
    nomfichier1 = getsdyn(nomfichier1);    /*Enregistre le nom du fichier source*/
    fichier = ouvre_fichier(nomfichier1,"r");
    do
    {
        rep = 'O';    /*Par defaut, la réponse est oui.*/
        puts("");
        puts("Dans quel fichier voulez-vous enregistrer le resultat? :");
        nomfichier2 = getsdyn(nomfichier2);        /*Enregistre le nom du fichier destination*/
        if (strcmp(nomfichier1,nomfichier2) == 0)        /*Si les 2 noms de fichiers sont identique*/
        {
            puts("");
            printf("Etes-vous sur de vouloir enregistrer sur le fichier d'origine? (O/N)");
            rep = getchar(); /*saisi réponse question*/
            getchar();       /*absorbe l'appui sur entrée*/
            if ((rep == 'o') || (rep == 'n'))
                rep = toupper(rep);    /*Si le caractère est minuscule, transforme en majuscule*/
        }
    } while (rep != 'O');            /*Tant que l'utilisateur veut changer de nom de fichier, continuer boucle*/
    Traitement_1(fichier);    /*1er traitement du fichier...*/
    fclose(fichier);
    fichier_final = ouvre_fichier(nomfichier2,"w");
    Traitement_2(fichier_final);    /*2e traitement du fichier...*/
    fclose(fichier_final);
    free(nomfichier1);
    free(nomfichier2);
    remove("tmp.txt");        /*Efface les fichier temporaires*/
    remove("tmp2.txt");
    puts("");
    printf("Le fichier a ete indenter. Le resultat se trouve dans le fichier \"%s\"\n", nomfichier2);
    Pause();        /*Traitement du fichier terminé !!!*/
    return 0;
}

void Traitement_1 (FILE* fichier)
{
    FILE* tmp;
    desindenteur(fichier);  /*Desindentation du fichier*/
    tmp = ouvre_fichier("tmp.txt","r");
    cmd_indent_1 (tmp);    /*1ere partie de l'indentation*/
    fclose(tmp);
}

void Traitement_2 (FILE* fichier_final)
{
    FILE* tmp2;
    tmp2 = ouvre_fichier ("tmp2.txt", "r");
    cmd_indent_2 (tmp2,fichier_final);    /*2e partie de l'indentation*/
    fclose(tmp2);
}

void cmd_indent_1 (FILE* tmp)    /*1ere partie de l'indentation*/
{
    FILE* tmp2;
    char chainesaisi[255];
    int nbtab=0, nOK, cazouver=0, comptcom=0;
    tmp2 = ouvre_fichier ("tmp2.txt", "w"); /*Ouvre un fichier 'temporaire'*/
    fgets(chainesaisi,255,tmp);    /*Saisi une première ligne*/
    while (feof(tmp) == 0)        /*Boucle jusqu'à la fin du fichier*/
    {
        nOK = 0;        /*Booléen nOK: indique qu'un terme est trouvé. Init à 0.*/
        compteur_com(chainesaisi,&comptcom);
        if (strstr(chainesaisi,"{") != NULL)        /*Si { trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"{",0,&comptcom)) == 1)   /*Si { à considérer*/
            {
                indenteur (chainesaisi, tmp2, nbtab);       /*Appel indenteur*/
                fgets(chainesaisi,255,tmp);                 /*Saisi ligne suivante*/
                nbtab++;                                    /*incrémente le compteur de tabulation.*/
                nOK=1;
            }
        }
        if (strstr(chainesaisi,"}") != NULL)        /*Si } trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"}",0,&comptcom)) == 1)
            {
                if (cazouver==1)                /*Si un 'case' à été ouvert auparavant sans avoir été refermé (permet ainsi de reculer la ligne suivante de 2 tabulation)*/
                    nbtab--;                                        /*décrémente le compteur de tabulation*/
                nbtab--;                        /*Décrémente le compteur de tabulation*/
                indenteur (chainesaisi, tmp2, nbtab);        /*Appel indenteur*/
                fgets(chainesaisi,255,tmp);
                cazouver=0;                    /*Referme tout 'case' ouvert*/
                nOK=1;
            }
        }
        if (strstr(chainesaisi,"case") != NULL)    /*Si 'case' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"case",1,&comptcom)) == 1)
            {
                if (cazouver == 0)             /*Si aucun 'case' n'a été ouvert sans être refermé*/
                {
                    indenteur (chainesaisi, tmp2, nbtab);
                    fgets(chainesaisi,255,tmp);
                    nbtab++;
                    cazouver=1;                /*'case' ouvert*/
                    nOK=1;
                }
                else                           /*Si un 'case' à été ouvert*/
                {
                    nbtab--;                    /*Décrémente compteur tabulation avant (pour afficher le 'case' en retrait d'une tabulation)*/
                    indenteur (chainesaisi, tmp2, nbtab);
                    fgets(chainesaisi,255,tmp);
                    nbtab++;                    /*Incrémente compteur tabulation*/
                    cazouver=1;                 /*'case' ouvert*/
                    nOK=1;
                }
            }
        }
        if (strstr(chainesaisi,"default:") != NULL)      /*Si 'default:' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"default:",1,&comptcom)) == 1)
            {
                nbtab--;                        /*Idem précedent...*/
                indenteur (chainesaisi, tmp2, nbtab);
                fgets(chainesaisi,255,tmp);
                nbtab++;
                cazouver=1;
                nOK=1;
            }
        }
        if (nOK == 0)
        {        /*Si aucune accolade n'est trouvée ou que le terme n'est pas considéré*/
            indenteur (chainesaisi, tmp2, nbtab);        /*appel indenteur sans changer le compteur de tabulation*/
            fgets(chainesaisi,255,tmp);
        }
    }
    fclose(tmp2);
}

void cmd_indent_2 (FILE* tmp2,FILE* fichier_final)            /*2e partie de l'indentation*/
{
    char chainesaisi[255];
    int chtrouv=0, comptcom=0;
    fgets(chainesaisi,255,tmp2);    /*Saisi une première ligne*/
    while (feof(tmp2) == 0)        /*Boucle jusqu'à la fin du fichier*/
    {
        compteur_com(chainesaisi,&comptcom);
        if (strstr(chainesaisi,"for(") != NULL)    /*Si 'for(' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"for(",0,&comptcom)) == 1) /*Si 'for(' à considérer*/
                chtrouv++;                /*Indique qu'un mot clé à été trouvé*/
        }
        if (strstr(chainesaisi,"for ") != NULL)    /*Si 'for ' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"for ",1,&comptcom)) == 1)
                chtrouv++;
        }
        if (strstr(chainesaisi,"if(") != NULL)    /*Si 'if(' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"if(",0,&comptcom)) == 1)
                chtrouv++;
        }
        if (strstr(chainesaisi,"if ") != NULL)    /*Si 'if ' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"if ",1,&comptcom)) == 1)
                chtrouv++;
        }
        if (strstr(chainesaisi,"while(") != NULL)    /*Si 'while(' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"while(",0,&comptcom)) == 1)
            {
                chtrouv++;
                if ((strstr(chainesaisi,";")) != NULL)   /*Si ; trouvé sur la même ligne que 'while('*/
                {
                    if ((verif_com_guil(chainesaisi,";",0,&comptcom)) == 1) /*Et ; a considérer*/
                        chtrouv++;                          /*Alors ignorer 'while('. Car while sert alors à terminer une boucle do-while.*/
                }
            }
        }
        if (strstr(chainesaisi,"while ") != NULL)    /*Si 'while ' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"while ",1,&comptcom)) == 1)
            {
                chtrouv++;
                if ((strstr(chainesaisi,";")) != NULL)        /*Idem précedent*/
                {
                    if ((verif_com_guil(chainesaisi,";",0,&comptcom)) == 1)
                        chtrouv--;
                }
            }
        }
        if (strstr(chainesaisi,"else") != NULL)    /*Si 'else' trouvé*/
        {
            if ((verif_com_guil(chainesaisi,"else",1,&comptcom)) == 1)
                chtrouv++;
        }
        if (chtrouv >= 1)         /*Si mot clé trouvé*/
        {
            chtrouv=0;            /*reinit chtrouv*/
            fprintstr(fichier_final,chainesaisi);     /*Ecrit la ligne saisi dans le fichier*/
            fgets(chainesaisi,255,tmp2);            /*Saisi la ligne suivante*/
            if ((strstr(chainesaisi,"{") == NULL) || ((strstr(chainesaisi,"{") != NULL) && (verif_com_guil(chainesaisi,"{",0,&comptcom)) == 0))
                indenteur (chainesaisi,fichier_final,1); /*Si ligne suivant le mot clé ne contient pas de { valide, indenter cette ligne*/
            else
                fprintstr(fichier_final,chainesaisi); /*Sinon ecrire directement la ligne*/
        }
        else                                       /*Si aucun mot clé n'est trouvé*/
            fprintstr(fichier_final,chainesaisi); /*Ecrire la ligne dans le fichier*/
        fgets(chainesaisi,255,tmp2);            /*Saisi la ligne suivante*/
    }
}

void desindenteur (FILE* fichier)        /*Retire les tabulations*/
{
    FILE* tmp;
    char chainesaisi[255];
    int i, erreur=1;
    tmp = ouvre_fichier("tmp.txt","w");
    while (feof(fichier) == 0)    /*Boucle jusqu'à la fin du fichier*/
    {
        erreur = (int) fgets(chainesaisi,255,fichier);    /*Saisi une première ligne*/
        while ((chainesaisi[0] == ' ') || (chainesaisi[0] == '\t'))     /*boucle tant que le 1er caractère de la ligne est un espace*/
        {
            for(i=0;i<(strlen(chainesaisi));i++)        /*Parcours la ligne caractère par caractère*/
                chainesaisi[i]=chainesaisi[i+1];       /*et décale la ligne d'un caractère vers la gauche*/
        }
        if (erreur)
            fprintstr(tmp, chainesaisi);         /*Ecrit la ligne désindentée*/
    }
    fclose(tmp);
}

void indenteur (char* chaine, FILE* fichier_final, int nbmit) /*Indente la ligne donnée*/
{
    int i=0;
    while (i<nbmit)     /*Boucle 'nbmit' fois, afin de placer 'nbmit' tabulation dans la ligne*/
    {
        fprintf(fichier_final,"    ");    /*Ecrit 4 espaces pour inscrire une tabulation*/
        i++;
    }
    fprintstr(fichier_final,chaine);     /*Ecrit la ligne à la suite des tabulations*/
}    /*RMQ: Si nbmit=0, la ligne n'est pas indenter, et écrite directement*/

int verif_com_guil (char* chainecomplete, char* chainepartielle, int mot, int* comptcom) /*vérifie que la chaine donnée soit à considérer*/
{
    int nbindexpart, nbindexguil, nbindexcomo, nbindexcomf, i, j=0, OK, indexmot;
    int indexguil[50]; /*Tableau des index de guillemets trouvé*/
    int indexcomo[50]; /*Tableau des index de commentaires ouvert trouvé*/
    int indexcomf[50]; /*Tableau des index de commentaires fermer trouvé*/
    int indexpart[50]; /*Tableau des index de 'chainepartielle' trouvée*/
    nbindexguil = index_ch(chainecomplete, "\"", indexguil); /*Trouve les guillemets dans la ligne*/
    nbindexcomo = index_ch(chainecomplete, "/*", indexcomo); /*Trouve les ouvertures de commentaires dans la ligne*/
    nbindexcomf = index_ch(chainecomplete, "*/", indexcomf); /*Trouve les fermetures de commentaires dans la ligne*/
    nbindexpart = index_ch(chainecomplete, chainepartielle, indexpart); /*Trouve les 'chainepartielle' dans la ligne*/
    if (*comptcom==1 && nbindexcomf==0)
        return 0;
    for (i=0;i<nbindexpart;i++)    /*Boucle sur le nombre de 'chainepartielle' trouvée*/
    {
        OK=1; /*Initialise OK à 1: donc terme à considérer*/
        if (nbindexguil > 0)        /*Si des guillemets ont été trouvés*/
        {
            for (j=0;j<(nbindexguil);j+=2)  /*Boucle tout les 2 guillemets*/
            {
                if ((indexguil[j] < indexpart[i]) && (indexguil[j+1] > indexpart[i]))
                    OK=0;    /*Si 'chainepartielle' se trouve entre 2 guillemets: Ne pas le considérer.*/
            }
        }
        if ((nbindexcomo > 0) && (nbindexcomf == 0))     /*Si un commentaire est ouvert (mais pas refermé)*/
        {
            *comptcom=1;
            for (j=0;j<nbindexcomo;j++)     /*Boucle sur le nombre de commentaire ouvert*/
            {
                if (indexcomo[j] < indexpart[i])
                    OK=0;    /*Si 'chainepartielle' se trouve après l'ouverture de commentaire: Ne pas le considérer*/
            }
        }
        if ((nbindexcomo == 0) && (nbindexcomf > 0))    /*Si un commentaire est fermé (mais pas ouvert)*/
        {
            *comptcom=0;
            for (j=0;j<nbindexcomf;j++)    /*Boucle sur le nombre de commentaire fermé*/
            {
                if (indexcomf[j] > indexpart[i])
                    OK=0;    /*Si 'chainepartielle' se trouve avant la fermeture de commentaire: Ne pas le considérer*/
            }
        }
        if ((nbindexcomo > 0) && (nbindexcomf > 0))     /*Si un commentaire est ouvert puis refermé*/
        {
            for (j=0;j<nbindexcomo;j++)     /*Boucle sur le nombre de commentaire ouvert*/
            {
                if ((indexcomo[j] < indexpart[i]) && (indexcomf[j] > indexpart[i]))
                    OK=0;    /*Si 'chainepartielle' se trouve entre l'ouverture et la fermeture du commentaire: Ne pas le considérer*/
            }
            *comptcom=1;
            if (indexcomf[nbindexcomf-1] > indexcomo[nbindexcomo-1])
                *comptcom=0;
        }
        if (mot == 1)                    /*Si 'chainepartielle' est un mot clé*/
        {
            indexmot = indexpart[i];
            if (indexpart[i] != 0)        /*Si le mot clé ne se trouve pas en début de ligne*/
            {
                if ((chainecomplete[indexmot-1] != '}') && (chainecomplete[indexmot-1] != ' '))
                    OK=0;   /*Si le caractère avant le mot clé n'est ni une } ni un espace: Ne pas le considérer (il fait partie du nom d'une variable)*/
            }
            if ((chainecomplete[indexmot+strlen(chainepartielle)] != ' ') && (chainecomplete[indexmot+strlen(chainepartielle)] != 0x28) && (indexmot+1+strlen(chainepartielle) != strlen(chainecomplete)))
                OK=0;   /*Si le caractère après le mot clé n'est ni une (,=0x28, ni un espace, ni \0: Ne pas le considérer (il fait partie du nom d'une variable)*/
        }
        if (OK==1) /* Si OK n'a pas été mis à 0, alors le mot clé doit être considérer*/
            return 1;        /*Renvoi 1*/
    }
    return 0; /*Si la boucle se termine sans avoir renvoyée 1, aucun des mots clés repérés ne doivent êtres considérer. Donc renvoi 0*/
}

void compteur_com (char* chainecomplete, int* comptcom) /*Détermine si les commentaires sont fermés ou non*/
{
    int nbindexcomo, nbindexcomf;
    int indexcomo[50]; /*Tableau des index de commentaires ouvert trouvé*/
    int indexcomf[50]; /*Tableau des index de commentaires fermer trouvé*/
    nbindexcomo = index_ch(chainecomplete, "/*", indexcomo); /*Trouve les ouvertures de commentaires dans la ligne*/
    nbindexcomf = index_ch(chainecomplete, "*/", indexcomf); /*Trouve les fermetures de commentaires dans la ligne*/
    if ((nbindexcomo > 0) && (nbindexcomf == 0))     /*Si un commentaire est ouvert (mais pas refermé)*/
        *comptcom=1;
    if ((nbindexcomo == 0) && (nbindexcomf > 0))    /*Si un commentaire est fermé (mais pas ouvert)*/
        *comptcom=0;
    if ((nbindexcomo > 0) && (nbindexcomf > 0))     /*Si un commentaire est ouvert puis refermé*/
    {
        *comptcom=1;
        if (indexcomf[nbindexcomf-1] > indexcomo[nbindexcomo-1])
            *comptcom=0;
    }
}

void fprintstr (FILE* fichier, char* chaine)    /*Ecrit dans le fichier, en respectant les % (qui veulent pas s'afficher normalement!!!)*/
{
    int tabindex[50];
    int nbindex, i,j=0;
    nbindex = index_ch (chaine,"%",tabindex); /*Trouve les % dans 'chaine'*/
    if (nbindex > 0)    /*Si des % ont été trouvé dans 'chaine'*/
    {
        for (i=0;i<strlen(chaine);i++)    /*Parcours 'chaine' caractère par caractère*/
        {
            if ((i == tabindex[j]) && (j<nbindex)) /*Si l'index actuel de 'chaine' correspond à l'index d'un %. Et si il reste des % non remplacé*/
            {
                fprintf(fichier,"%c",'%');    /*Ecrit le caractère % à la suite de la ligne*/
                j++; /*Incrémente le nombre de % remplacé*/
            }
            else
                fprintf(fichier,"%c",chaine[i]); /*Ecrit le caractère de l'index actuel de 'chaine' à la suite de la ligne*/
        }
    }
    else
        fprintf(fichier,"%s",chaine);     /*Si aucun % n'est trouvé, écrit la chaine directement*/
}
